$(function() {

  function openPopup(arg) {
    $("#popup").addClass("active");
    $("#popup ." + arg).addClass("active");
    myFullpage.setMouseWheelScrolling(false);
  }

  function closePopup(arg) {
    $("#popup").removeClass("active");
    $("#popup ." + arg).removeClass("active");
    myFullpage.setMouseWheelScrolling(true);
  }

  $("#nabors .link").click(function() {
    openPopup($(this).attr("data-popup"));
  });

  $(".form-checkbox .box").click(function() {
    let input = $("input", $(this));

    if (input.val() == "on") {
      input.val("off");
    } else {
      input.val("on");
    }

    $(this).toggleClass("active");
  });

  $("#payment-button").click(function() {
    if ($("#ch1").val() == "off" || $("#ch2").val() == "off") {
      note({
        content: '<b><i class="fa-solid fa-circle-xmark"></i>Ошибка</b><br>Вы не подтвердили все условия.',
        type: "info",
        time: 5,
      });
      return false;
    }
  });

  $("#rub_input").on("input", function() {
    $("#dl_math").html($(this).val() * 2);
  });

  $("#donate_block").click(function() {
    note({
      content: '<b><i class="fa-solid fa-circle-xmark"></i>Ошибка</b><br>Раздел в разработке.',
      type: "info",
      time: 5,
    });
    return false;
  });

  $("#popup .js-nabor-buy-form").on("submit", function() {
    $.ajax({
      url: '/api/',
      method: 'post',
      dataType: 'html',
      data: $(this).serialize(),
      success: function (data) {
        if (data == "money_error") {
          note({
            content: '<b><i class="fa-solid fa-circle-xmark"></i>Ошибка</b><br>Недостаточно средств.',
            type: "info",
            time: 5,
          });
        } else if (data == "auth_error") {
          note({
            content: '<b><i class="fa-solid fa-circle-xmark"></i>Ошибка</b><br>Вы не авторизировались.',
            type: "info",
            time: 5,
          });
        } else if (data == "buy_error") {
          note({
            content: '<b><i class="fa-solid fa-circle-xmark"></i>Ошибка</b><br>Вы уже приобрели данный набор.',
            type: "info",
            time: 5,
          });
        } else if (data == "ok") {
          note({
            content: '<b><i class="fa-solid fa-circle-check"></i>Успешно</b><br>Вы приобрели новый набор.',
            type: "info",
            time: 5,
          });

          setTimeout(function() {
            note({
              content: '<b><i class="fa-solid fa-circle-check"></i>Информация</b><br>Активировать его можно в личном кабинете.',
              type: "info",
              time: 5,
            });
          }, 1000);
        }
      }
    });

    return false;
  });
});